/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mshg terrain;  // terrain mesh
Mesh grass;    // grass   mesh
Vec  pos[600]; // grass   positions
/******************************************************************************/
void InitPre()
{
   App.name="Grass";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).ambPower(0.3).shdMapSize(1024).shdSoft(1);
   ViewportFull.range=30;
}
/******************************************************************************/
Bool Init()
{
   Cam.dist =6;
   Cam.pitch=-1;
   Sun.set(*Gfxs("gfx/sky/sun.gfx")); // sun
   Sky.set();                         // sky

   // load terrain mesh
   terrain.load("obj/terrain/0.mshg");

   // create grass mesh
   grass.create(1).B(0).createGrass(48);
   grass.setMaterial(Materials("mtrl/grass/blade.mtrl")).setRender().setBox();

   // set random positions on terrain surface
   REPA(pos)PosPointMeshY(Rnd(terrain.box).xz()*0.4,terrain,&pos[i]);

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT)); // move camera on right mouse button
   UpdateGrassAndLeafs(); // update grass bending
   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SHD_MAP:
      case RM_SOLID  :
         REPA(pos)grass  .draw(Matrix(0.25,pos[i]));
                  terrain.draw(MatrixIdentity);
      break;
   }
}
void Draw()
{
   Renderer(Render);
}
/******************************************************************************/
